<?php

class Api_model extends CI_Model
{
    function __consturct()
    {
        parent::__construct();
    }

    public function SelectData($table = null, $field = null, $cond = null, $limit = null, $order = null)
    {
        $this->db->select($field);
        $this->db->from($table);
        $this->db->where($cond);
        $query = $this->db->get();
        $data = $query->result();
        if ($data) {
            return $data;
        } else {
            return false;
        }
    }

    public function update($table_name, $condition, $data)
    {
        return $this->db->where($condition)->update($table_name, $data);
    }
    public function update_data($table, $field, $id, $data)
    {
        $this->db->where($field, $id);
        return $this->db->update($table, $data);
    }
    function register($register)
    {
        $this->db->insert('grocery_users', $register);
        return $this->db->insert_id();
    }

    function is_registered1($phone_no)
    {
        //$mob=$_COOKIE['Mobile'];

        $sql = "SELECT `phone` FROM `grocery_seller` WHERE `phone`= '$phone_no'";
        $que1 = $this->db->query($sql);
        $output = $que1->num_rows();
        if ($output == 0) {
            $sql = "SELECT `phone` FROM `grocery_users` WHERE `phone`= '$phone_no'";
            $que = $this->db->query($sql);
            $output2 = $que->num_rows();
            if ($output2 == 1) {
                return true;
            } else {
                return false;
            }
        } else {
            return true;
        }
    }
    function helpdesk_registered($user_id)
    {
        $sql = "SELECT * FROM `help_desk` WHERE `phone`= '$user_id'";
        $que1 = $this->db->query($sql);
        $output = $que1->num_rows();
        if ($output == 0) {
            return false;
        } else {
            return true;
        }
    }

    function verifyotp($user_id)
    {
        $this->db->select('*,mobile_otp.otp as otp');
        $this->db->from('mobile_otp');
        $this->db->join('grocery_users', 'grocery_users.user_id=mobile_otp.user_id', 'left');
        $this->db->where('mobile_otp.user_id', $user_id);
        $query = $this->db->get();
        return $query->row_array();
    }
    function productdetail($product_id)
    {
        $this->db->select('*,grocery_product_images.image,grocery_product_size.weight');
        $this->db->from('grocery_product');
        $this->db->join(' grocery_product_size', 'grocery_product_size.product_id=grocery_product.id', 'left');
        $this->db->join('grocery_product_images', 'grocery_product_images.product_id=grocery_product.id', 'left');
        $this->db->where('grocery_product.id', $product_id);
        $query = $this->db->get();
        return $query->row_array();
    }

    public function get_maincategory($domain)
    {
        $this->db->select('*');
        $this->db->from('grocery_maincategory');
        $this->db->where('grocery_maincategory.domain', $domain);
        $this->db->where('grocery_maincategory.status', '1');
        $query = $this->db->get();
        return $query->result_array();
    }
    public function get_festivalcategory($domain)
    {
        $this->db->select('*');
        $this->db->from('grocery_maincategory');
        $this->db->where('grocery_maincategory.domain', $domain);
        $this->db->where('grocery_maincategory.status', '1');
        $this->db->where('grocery_maincategory.Festival', '1');
        $this->db->where('grocery_maincategory.id', '3');
        $query = $this->db->get();
        return $query->row_array();
    }
  public function get_idwisecategory($domain,$id)
    {
        $this->db->select('*');
        $this->db->from('grocery_maincategory');
        $this->db->where('grocery_maincategory.domain', $domain);
        $this->db->where('grocery_maincategory.status', '1');
        
        $this->db->where('grocery_maincategory.id', $id);
       
        $query = $this->db->get();
        return $query->row_array();
    }
 public function get_maincategorylimit($domain)
    {
        $this->db->select('*');
        $this->db->from('grocery_maincategory');
        $this->db->where('grocery_maincategory.domain', $domain);
        $this->db->where('grocery_maincategory.status', '1');
        $this->db->limit('2');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_categorylimit($domain, $id)
    {
        $this->db->select('*');
        $this->db->from('grocery_categories');
        $this->db->where('grocery_categories.domain', $domain);
        $this->db->where('grocery_categories.maincat_id', $id);
        $this->db->where('grocery_categories.status', '1');
       // $this->db->limit('8');
        $query = $this->db->get();
        return $query->result_array();
    }  
    public function get_indexsection($domain)
    {
        $this->db->select('*');
        $this->db->from('indexsection_setting');
        $this->db->where('status', '1');
        $this->db->where('domain', $domain);
        $this->db->order_by('position','ASC');
        $query = $this->db->get();
        return $query->result_array();
    } 
    public function get_category($domain, $id)
    {
        $this->db->select('*');
        $this->db->from('grocery_categories');
        $this->db->where('grocery_categories.domain', $domain);
        $this->db->where('grocery_categories.maincat_id', $id);
        $this->db->where('grocery_categories.status', '1');

        $query = $this->db->get();
        return $query->result_array();
    }
    public function get_categorywithid($id)
    {
        $this->db->select('*');
        $this->db->from('grocery_categories');
        $this->db->where('grocery_categories.id', $id);
        $this->db->where('grocery_categories.status', '1');
        $query = $this->db->get();
        return $query->row_array();
    }
    public function get_subcategory($id)
    {
        $this->db->select('*');
        $this->db->from('grocery_sub_categories');
        $this->db->where('grocery_sub_categories.cat_id', $id);
        $this->db->where('grocery_sub_categories.status', '1');

        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_product($domain, $pincode)
    {
        $this->db->select('grocery_product.*,grocery_sub_categories.subcat_name,grocery_categories.cat_name,grocery_product_images.image,
     grocery_product_size.weight,grocery_product_size.price,grocery_product_size.discount');
        $this->db->from('grocery_product');
        $this->db->join('grocery_sub_categories', 'grocery_sub_categories.id=grocery_product.subcat_id');
        $this->db->join('grocery_categories', 'grocery_categories.id=grocery_product.cat_id');
        $this->db->join('grocery_product_images', 'grocery_product_images.product_id=grocery_product.id', 'left');
        $this->db->join(' grocery_product_size', 'grocery_product_size.product_id=grocery_product.id', 'left');
        $this->db->join('grocery_seller', 'grocery_seller.seller_id=grocery_product.sellar_id');
        $this->db->where('grocery_seller.added_by_web', $domain);
        $this->db->where('grocery_seller.pincode', $pincode);
        $this->db->where('grocery_product.stauts', '1');
        $this->db->where('grocery_product.leave_stauts', '1');
        $this->db->group_by('grocery_product_size.product_id');

        $query = $this->db->get();
        return $query->result_array();
    }
     public function get_productvideo($domain,$seller_id,$seller_auto_id)
    {
 
        
        
         $query1 = $this->db->query(
            "SELECT DISTINCT grocery_product.*,
            IFNULL((SELECT discount_percent AS discount FROM grocery_offer_banner WHERE FIND_IN_SET(grocery_product.id,productid) AND status='Active' AND '".date('Y-m-d')."' BETWEEN start_date AND expiry_date ORDER BY id DESC LIMIT 1),0) AS extra_dicounts,
            IFNULL((grocery_product_size.stock-grocery_product_size.outofstock),0) AS available_stock,
        grocery_product_size.weight,grocery_product_size.price,grocery_product_size.discount,grocery_product_size.id as sizeid
        FROM grocery_product  
        INNER JOIN grocery_seller ON  grocery_seller.seller_id=grocery_product.sellar_id AND grocery_seller.id='$seller_auto_id' AND grocery_seller.seller_id='$seller_id' AND grocery_seller.added_by_web='$domain'
        INNER JOIN grocery_product_size ON grocery_product_size.product_id=grocery_product.id
        WHERE grocery_product.stauts=1 AND grocery_product.leave_stauts = 1  AND grocery_product.video <> ' '
        GROUP BY grocery_product.id ORDER BY grocery_product.id DESC,grocery_product_size.price DESC"
        );

        return $query1->result_array();
    }

    public function get_leatest_product($domain,$seller_id,$seller_auto_id)
    {
      
        
        $query1 = $this->db->query(
            "SELECT DISTINCT grocery_product.*,
            IFNULL((SELECT discount_percent AS discount FROM grocery_offer_banner WHERE FIND_IN_SET(grocery_product.id,productid) AND status='Active' AND '".date('Y-m-d')."' BETWEEN start_date AND expiry_date ORDER BY id DESC LIMIT 1),0) AS extra_dicounts,
            IFNULL((grocery_product_size.stock-grocery_product_size.outofstock),0) AS available_stock,
        grocery_product_size.weight,grocery_product_size.price,grocery_product_size.discount,grocery_product_size.id as sizeid
        FROM grocery_product  
        INNER JOIN grocery_seller ON  grocery_seller.seller_id=grocery_product.sellar_id AND grocery_seller.id='$seller_auto_id' AND grocery_seller.seller_id='$seller_id' AND grocery_seller.added_by_web='$domain'
        INNER JOIN grocery_product_size ON grocery_product_size.product_id=grocery_product.id
        WHERE grocery_product.stauts=1 AND grocery_product.leave_stauts = 1
        GROUP BY grocery_product.id ORDER BY grocery_product.id DESC,grocery_product_size.price DESC"
        );

        return $query1->result_array();
        
        
     
    }

    public function get_mostdiscount_product($domain,$seller_id,$seller_auto_id)
    {
        
        $query1 = $this->db->query(
            "SELECT tmp.*,(tmp.discount+tmp.extra_dicounts) As total_dsicount FROM(SELECT DISTINCT grocery_product.*,
            IFNULL((SELECT discount_percent AS discount FROM grocery_offer_banner WHERE FIND_IN_SET(grocery_product.id,productid) AND status='Active' AND '".date('Y-m-d')."' BETWEEN start_date AND expiry_date ORDER BY id DESC LIMIT 1),0) AS extra_dicounts,
            IFNULL((grocery_product_size.stock-grocery_product_size.outofstock),0) AS available_stock,
            grocery_product_size.weight,grocery_product_size.price,grocery_product_size.discount,grocery_product_size.id as sizeid
            FROM grocery_product  
            INNER JOIN grocery_seller ON  grocery_seller.seller_id=grocery_product.sellar_id AND grocery_seller.id='$seller_auto_id' AND grocery_seller.seller_id='$seller_id' AND grocery_seller.added_by_web='$domain'
            INNER JOIN grocery_product_size ON grocery_product_size.product_id=grocery_product.id
            WHERE grocery_product.stauts=1 AND grocery_product.leave_stauts = 1
            GROUP BY grocery_product.id ORDER BY grocery_product.id DESC,grocery_product_size.price DESC) AS tmp ORDER BY total_dsicount DESC"
        );
        
        
        return $query1->result_array();
    }

    public function get_catwise_product($id, $domain)
    {
  
        
        $query1 = $this->db->query(
            "SELECT DISTINCT grocery_product.*,
        IFNULL((SELECT discount_percent AS discount FROM grocery_offer_banner WHERE FIND_IN_SET(grocery_product.id,productid) AND status='Active' AND '".date('Y-m-d')."' BETWEEN start_date AND expiry_date ORDER BY id DESC LIMIT 1),0) AS extra_dicounts,  
        IFNULL((grocery_product_size.stock-grocery_product_size.outofstock),0) AS available_stock,
        grocery_product_size.weight,grocery_product_size.price,grocery_product_size.discount,grocery_product_size.id as sizeid
        FROM grocery_product  
        INNER JOIN grocery_seller ON  grocery_seller.seller_id=grocery_product.sellar_id AND grocery_seller.added_by_web='$domain'
        INNER JOIN grocery_product_size ON grocery_product_size.product_id=grocery_product.id
        WHERE grocery_product.stauts=1 AND grocery_product.leave_stauts = 1 AND grocery_product.cat_id= $id 
        GROUP BY grocery_product.id ORDER BY grocery_product.id DESC,grocery_product_size.price DESC"
        );

        return $query1->result_array();
        
    }

   
    
    public function search_product($product_name,$user_id)
    {
        
        
        $query1 = $this->db->query(
            "SELECT DISTINCT grocery_product.*,CASE WHEN (cart_data.id  > 0) THEN 1 ELSE 0 END AS cart_exist,
        CASE WHEN (cart_data.id  > 0) THEN cart_data.product_qty ELSE 0 END AS productQty,
        CASE WHEN (wishlist_data.id  > 0) THEN 1 ELSE 0 END AS wishlist_exist,
        grocery_product_size.weight,grocery_product_size.price,grocery_product_size.discount,grocery_product_size.id as sizeid
        FROM grocery_product  
             join grocery_sub_categories ON `grocery_sub_categories`.id = `grocery_product`.subcat_id 
             join grocery_categories ON `grocery_categories`.id = `grocery_product`.cat_id 
           
             join grocery_product_images ON `grocery_product_images`.product_id = `grocery_product`.id 
             join grocery_product_size ON `grocery_product_size`.product_id = `grocery_product`.id 
             LEFT JOIN cart_data ON grocery_product.id=cart_data.product_id AND cart_data.user_id='$user_id'
             LEFT JOIN wishlist_data ON grocery_product.id=wishlist_data.product_id AND wishlist_data.user_id='$user_id'
             WHERE grocery_product.product_name LIKE  '%".$product_name."%' 
            
             OR grocery_categories.`cat_name` LIKE  '%".$product_name."%' 
             OR grocery_sub_categories.`subcat_name` LIKE  '%".$product_name."%'
            AND grocery_product.stauts=1 AND grocery_product.leave_stauts = 1 
             GROUP BY grocery_product.id ORDER BY grocery_product.id DESC,grocery_product_size.price DESC"
        );

        return $query1->result_array();
        
        
      
    } 
    
    
   public function get_offerproduct($product_id,$domain,$seller_id,$seller_auto_id)
    {
        

                
                $query1 = $this->db->query(
                    "SELECT grocery_product.*,
                    IFNULL((SELECT discount_percent AS discount FROM grocery_offer_banner WHERE FIND_IN_SET(grocery_product.id,productid) AND status='Active' AND '".date('Y-m-d')."' BETWEEN start_date AND expiry_date ORDER BY id DESC LIMIT 1),0) AS extra_dicounts,
                    IFNULL((grocery_product_size.stock-grocery_product_size.outofstock),0) AS available_stock,
            grocery_product_size.weight,
            grocery_product_size.price,
            grocery_product_size.discount,
            grocery_product_size.id AS sizeid
        FROM grocery_product
        INNER JOIN grocery_seller ON grocery_seller.seller_id = grocery_product.sellar_id AND grocery_seller.id='$seller_auto_id' AND grocery_seller.seller_id='$seller_id' AND grocery_seller.added_by_web = '$domain'
        INNER JOIN grocery_product_size ON grocery_product_size.product_id = grocery_product.id
        WHERE grocery_product.stauts = 1 AND grocery_product.domain='$domain'
            AND grocery_product.leave_stauts = 1
            AND grocery_product.id IN ($product_id)
        GROUP BY grocery_product.id
        ORDER BY grocery_product.id DESC, grocery_product_size.price DESC");
               
        return $query1->result_array();
        
        
      
    } 
  
    public function get_product_detail($id, $domain)
    {
        $this->db->select("grocery_product.*,grocery_product_images.image,
        IFNULL((SELECT discount_percent AS discount FROM grocery_offer_banner WHERE FIND_IN_SET(grocery_product.id,productid) AND status='Active' AND '".date('Y-m-d')."' BETWEEN start_date AND expiry_date ORDER BY id DESC LIMIT 1),0) AS extra_dicounts,
        IFNULL((grocery_product_size.stock-grocery_product_size.outofstock),0) AS available_stock,
     grocery_product_size.weight,grocery_product_size.price,grocery_product_size.discount,grocery_product.id as id");
        $this->db->from('grocery_product');
        $this->db->join('grocery_product_images', 'grocery_product_images.product_id=grocery_product.id');
        $this->db->join(' grocery_product_size', ' grocery_product_size.product_id=grocery_product.id');
        $this->db->join('grocery_seller', 'grocery_seller.seller_id=grocery_product.sellar_id');
        $this->db->where('grocery_seller.added_by_web', $domain);
        $this->db->where('grocery_product.stauts', '1');
        $this->db->where('grocery_product.leave_stauts', '1');
        $this->db->where('grocery_product.domain', $domain);
        $this->db->where('grocery_product.id', $id);
       
        $query = $this->db->get();
        return $query->row_array();
    }
    public function multiimage($id)
    {
        $this->db->select('*');
        $this->db->from('grocery_product_images');
        $this->db->where('product_id', $id);

        $query = $this->db->get();
        return $query->result_array();
    }
    public function multiweight($id)
    {
        $this->db->select('*');
        $this->db->from('grocery_product_size');
        $this->db->where('product_id', $id);

        $query = $this->db->get();
        return $query->result_array();
    }

    public function getProductRating($id_)
    {
        try {
            $this->db->select('ROUND(AVG(rating),1) as rating');
            $this->db->from('comments_reviews');
            $this->db->where('product_id', $id_);
            $this->db->where("is_approved", '1');
            $this->db->where('delete_flag', '0');
            $query = $this->db->get();
            if ($this->db->affected_rows() > 0) {
                $rating = $query->row()->rating;

                $userarray = [
                    'rating' => $rating,
                ];
                return $userarray;
            } else {
                return false;
            }
        } catch (Exception $ex) {
            error_log($ex->getTraceAsString());
            echo $ex->getTraceAsString();
            return false;
        }
    }

    public function getUserReviewById($id_)
    {
        try {
            $this->db->select('*');
            $this->db->from('comments_reviews');
            $this->db->where('product_id', $id_);
            $this->db->where('delete_flag', '0');
            //            $this->db->order_by('created_at', 'DESC');
            $query = $this->db->get();
            $review_list = [];
            if ($query->num_rows() > 0) {
                foreach ($query->result() as $row) {
                    $array = [
                        'id' => $row->id,
                        'product_id' => $row->product_id,
                        'user_id' => $row->user_id,
                        'user_name' => $row->user_name,
                        'reviews' => $row->reviews,
                        'rating' => $row->rating,
                        'comments' => $row->comments,
                        'admin_reply' => $row->admin_reply,
                        'created' => date('d/m/Y', strtotime($row->created)),
                        'is_approved' => $row->is_approved,
                    ];
                    array_push($review_list, $array);
                }
            }
            return $review_list;
        } catch (Exception $ex) {
            error_log($ex->getTraceAsString());
            echo $ex->getTraceAsString();
            return false;
        }
    }

   public function get_related_product($catid,$productid,$domain)
    {
    
        
        
        $qry="SELECT DISTINCT grocery_product.*,
        IFNULL((SELECT discount_percent AS discount FROM grocery_offer_banner WHERE FIND_IN_SET(grocery_product.id,productid) AND status='Active' AND '".date('Y-m-d')."' BETWEEN start_date AND expiry_date ORDER BY id DESC LIMIT 1),0) AS extra_dicounts,
        IFNULL((grocery_product_size.stock-grocery_product_size.outofstock),0) AS available_stock,
        grocery_product_size.weight,grocery_product_size.price,grocery_product_size.discount,grocery_product_size.id as sizeid
        FROM grocery_product  
        INNER JOIN grocery_seller ON  grocery_seller.seller_id=grocery_product.sellar_id AND grocery_seller.added_by_web='$domain'
        INNER JOIN grocery_product_size ON grocery_product_size.product_id=grocery_product.id
        WHERE grocery_product.cat_id='$catid' AND grocery_product.domain='$domain' AND grocery_product.id <> '$productid' AND grocery_product.stauts=1 AND grocery_product.leave_stauts = 1 GROUP BY grocery_product.id ORDER BY grocery_product.id ASC,grocery_product_size.price ASC LIMIT 10";
        return $this->db->query($qry)->result_array();

        
    }


    public function wishlist_data($user_id)
    {
        $query1 = $this->db->query(
            "SELECT * FROM grocery_product INNER JOIN wishlist_data ON grocery_product.id= wishlist_data.product_id 
            WHERE wishlist_data.user_id='$user_id' AND wishlist_data.is_added_cart=0 "
        );

        return $query1->result_array();
    }
    public function mycart_data($user_id)
    {
        $cart_query3 = $this->db->query(
            "SELECT *, (SELECT product_name FROM `grocery_product` WHERE id=cart_data.product_id) as product_name,(SELECT price FROM `grocery_product` WHERE id=cart_data.product_id) as price ,(SELECT stock FROM `grocery_product` WHERE id=cart_data.product_id) as in_stock FROM `cart_data` WHERE  `user_id` ='$user_id' AND `is_purchased` =0 AND `save_for_later` =0 "
        );

        return $cart_query3->result_array();
    }
    public function saveforleter($user_id)
    {
        $save_for_query1 = $this->db->query(
            "SELECT grocery_product.`product_name` , grocery_product.`stock` ,cart_data.`id`,cart_data.`user_id`,cart_data.`product_qty`,cart_data.`product_id`, `cart_data`.product_price , `cart_data`.product_weight ,`cart_data`.product_discount , `cart_data`.product_name , `cart_data`.product_image  FROM `cart_data` inner join grocery_product ON `cart_data`.product_id = `grocery_product`.id AND `cart_data`.`user_id` ='$user_id' AND  `cart_data`.`is_purchased` =0 AND `save_for_later` =1 GROUP BY `cart_data`.`product_id`"
        );

        return $save_for_query1->result_array();
    }

    public function all_notification($user_id)
    {
        $this->db->select('*');
        $this->db->from('tbl_notification');
        $this->db->where('tbl_notification.add_to', $user_id);
        $this->db->where('tbl_notification.view_status', 0);
        $this->db->order_by('tbl_notification.id', 'desc');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function order($user_id)
    {
        $this->db->select('*,payment_details.id as payid');
        $this->db->from('payment_details');
        $this->db->join('customer_address', 'customer_address.id=payment_details.address1', 'left');
        $this->db->where('payment_details.user_id', $user_id);
        $this->db->where('payment_details.status', 'success');
        $this->db->order_by('payment_details.id', 'desc');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function order_detail($id, $user_id)
    {
        $this->db->select('*,payment_details.id as payid,product_placed.id as placeid,grocery_categories.cat_name,product_placed.product_image as product_image');
        $this->db->from('payment_details');
        $this->db->join('customer_address', 'customer_address.id=payment_details.address1', 'left');
        $this->db->join('product_placed', 'payment_details.id=product_placed.payment_id', 'left');
        $this->db->join('grocery_product', 'grocery_product.id=product_placed.product_id', 'left');
        $this->db->join('grocery_categories', 'grocery_categories.id=grocery_product.cat_id');
        $this->db->where('payment_details.user_id', $user_id);
        $this->db->where('payment_details.status', 'success');
        $this->db->where('payment_details.order_id', $id);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function delivertcancel($order_id)
    {
        $this->db->select('Deliveryboy_ordercancel.created as deliverycancel_date,Deliveryboy_ordercancel.cancel_comment,Deliveryboy_ordercancel.order_id,Deliveryboy_ordercancel.payid');
        $this->db->from('payment_details');
        $this->db->join('Deliveryboy_ordercancel', 'Deliveryboy_ordercancel.order_id=payment_details.order_id');

        $this->db->where('payment_details.order_id', $order_id);
        $this->db->order_by('Deliveryboy_ordercancel.id', 'desc');
        $query = $this->db->get();
        return $query->result_array();
    }
    public function get_allpromotion()
    {
        $date = date("Y-m-d");
        $this->db->select('*');
        $this->db->from('grossry_promocode');
        $this->db->where('start_date <=', $date);
        $this->db->where('expiry_date >=', $date);
        $this->db->where('status', 'Active');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_Charge()
    {
        $this->db->select('*');
        $this->db->from('grocery_delivery_charge');
        $this->db->where('status', 'Active');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function customer_address($user_id)
    {
        $query = $this->db->query("SELECT * from customer_address WHERE `user_id` ='$user_id' AND status='1'");
        return $query->result_array();
    }
    
 public function customer_lastaddress($user_id,$lastid)
    {
        $query = $this->db->query("SELECT * from customer_address WHERE `user_id` ='$user_id' AND `id`= $lastid AND status='1'");
        return $query->result_array();
    }

    public function isExistProduct($user_id, $product_id)
    {
        try {
            $this->db->select('id');
            $this->db->from('product_placed');
            $this->db->where('user_id', $user_id);
            $this->db->where('product_id', $product_id);
            $this->db->where('product_status', 'D');
            // $this->db->or_where('order_status','S');
            $query = $this->db->get();
            // echo print_r($query);
            if ($this->db->affected_rows() > 0) {
                return true;
            } else {
                return false;
            }
        } catch (Exception $ex) {
            error_log($ex->getTraceAsString());
            echo $ex->getTraceAsString();
            return false;
        }
    }

    public function isUserExist($user_id, $product_id)
    {
        try {
            $this->db->select('id');
            $this->db->from('comments_reviews');
            $this->db->where('user_id', $user_id);
            $this->db->where('product_id', $product_id);
            $query = $this->db->get();
            if ($this->db->affected_rows() > 0) {
                return true;
            } else {
                return false;
            }
        } catch (Exception $ex) {
            error_log($ex->getTraceAsString());
            echo $ex->getTraceAsString();
            return false;
        }
    }

    public function insertRating($data)
    {
        try {
            $this->db->insert('comments_reviews', $data);
            if ($this->db->affected_rows() > 0) {
                return true;
            } else {
                return false;
            }
        } catch (Exception $ex) {
            error_log($ex->getTraceAsString());
            echo $ex->getTraceAsString();
            return false;
        }
    }

    public function get_sellerid($id)
    {
        $this->db->select('sellar_id');
        $this->db->from('grocery_product');
        $this->db->where('grocery_product.id', $id);
        $query = $this->db->get();
        return $query->row();
    }
    public function cart_query3($user_id)
    {
        $cart_query3 = $this->db->query(
            "SELECT *, (SELECT product_name FROM `grocery_product` WHERE id=cart_data.product_id) as product_name,(SELECT price FROM `grocery_product` WHERE id=cart_data.product_id) as price ,(SELECT stock FROM `grocery_product` WHERE id=cart_data.product_id) as in_stock FROM `cart_data` WHERE  `user_id` ='$user_id' AND `is_purchased` =0 AND `save_for_later` =0 "
        );

        return $cart_query3->result_array();
    }

    public function GetAddresses($addesId)
    {
        $this->db->select('customer_address.*');
        $this->db->from('customer_address');
        $this->db->join('countries', 'countries.id=customer_address.country', 'left');
        $this->db->join('states', 'states.id=customer_address.state', 'left');
        $this->db->join('cities', 'cities.id=customer_address.city', 'left');
        $this->db->where('customer_address.id', $addesId);
        $query = $this->db->get();
        return $query->row();
    }
    function paynow($paynow)
    {
        $this->db->insert('payment_details', $paynow);
        return $this->db->insert_id();
    }
    public function get_brand()
    {
        $this->db->select('*');
        $this->db->from('grocery_brand');
        $this->db->where('status', '1');
        $query = $this->db->get();
        return $query->result_array();
    }

    public function Execute($q, $w = [])
    {
        $query = $this->db->query($q, $w);
        if ($query) {
            return $query;
        } else {
            return false;
        }
    }

    public function verify_user($userid)
    {
        $query = $this->db->get_where('grocery_users', ['user_id' => $userid]);
        return $query->num_rows() > 0;
    }
    function set_f_token_app($user_id, $token)
    {
        $this->db->where('user_id', $user_id);
        $this->db->update('grocery_users', ['f_token_app' => $token]);
    }
    function set_f_tokenphone_app($phone, $token)
    {
        $this->db->where('phone', $phone);
        $this->db->update('grocery_users', ['f_token_app' => $token]);
    }
    
    
    public function Insert($table, $f)
    {
        $query = $this->db->insert($table, $f);
        if ($query) {
            $insert_id = $this->db->insert_id();

            return $insert_id;
        } else {
            return false;
        }
    }
    
     public function orderdetail($id,$user_id)
    {
        $qry="SELECT p.*,a.*,DATE_FORMAT(p.created,'%d/%m/%Y %h:%i %p') as createddate 
        FROM payment_details p 
        INNER JOIN customer_address a ON a.id=p.address1
        WHERE (p.order_id)='$id' AND p.user_id='$user_id'";
        return $this->db->query($qry)->row_array();
    }
    
      public function sub_orderdetail($id)
    {
        $qry="SELECT p.*,gp.product_name AS productname,gp.product_image AS productimage FROM product_placed p 
        INNER JOIN grocery_product gp ON gp.id=p.product_id
        WHERE (p.order_id)='$id'";
        return $this->db->query($qry)->result_array();
    }
    
    
    public function checkLocality($latitude,$longitude)
    {
        
        $qry="SELECT tmp.* FROM (SELECT *,round(( 6371 * acos( cos( radians(round($latitude,2)) ) * cos( radians( latitude) ) *
            cos( radians( longitude) - radians(round($longitude,2)) ) + sin( radians(round($latitude,2)) ) * sin( radians(latitude) ) ) )) AS distance
            FROM grocery_seller WHERE status=1) AS tmp WHERE tmp.distance <= 20 ORDER BY tmp.distance ASC Limit 1";
   
        return $this->db->query($qry)->row_array();
    }
}
