<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Redirect to Google Maps</title>
</head>
<body>
    <!-- Content -->
      <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAKgqAyTO5G0rIf8laUc5_gOaF16Qwjg2Y&libraries=places"></script>
    <script>
        // Function to redirect to Google Maps with directions
        function redirectToGoogleMaps(currentLocation, destinationAddress) {
            // Construct the URL for Google Maps directions
            var mapsUrl = 'https://www.google.com/maps/dir/?api=1';
            mapsUrl += '&origin=' + encodeURIComponent(currentLocation);
            mapsUrl += '&destination=' + encodeURIComponent(destinationAddress);

            // Redirect to Google Maps
            window.location.href = mapsUrl;
        }

        // Example usage
        document.addEventListener('DOMContentLoaded', function() {
            // Example data (replace with actual values)
            var destinationAddress = '<?php echo $dest ;?>'; // Replace with the customer's address

            // Get current location using Geolocation API
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(function(position) {
                    var currentLocation = position.coords.latitude + ',' + position.coords.longitude;

                    // Redirect to Google Maps
                    redirectToGoogleMaps(currentLocation, destinationAddress);
                }, function(error) {
                    // Handle errors here if geolocation fails
                    console.error('Error getting current location:', error);
                });
            } else {
                // Geolocation not supported by browser
                console.error('Geolocation is not supported by this browser.');
            }
        });
    </script>
</body>
</html>
