<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Driver extends CI_Controller {

    public function __construct(){
        
		parent::__construct();
		 $this->load->helper('email'); 
		 $this->load->model('Apidriver_model');
		 
        $sql =  "SELECT * FROM tbl_api_auth";
        $api_auth= $this->db->query($sql)->row_array();

        if(($_SERVER['PHP_AUTH_USER'] != $api_auth['username']) || ($_SERVER['PHP_AUTH_PW'] != $api_auth['password']))
        {
            header("Access-Control-Allow-Origin: *");
            header("Content-Type: application/json; charset=UTF-8");
            $response['status']='error';
            $response['statusCode']=400;
            $response['message']='Authentication failed';
            echo json_encode($response);
            die;
        }
 
    }
    

	public function phone_login(){
         header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		$status='error';
		$message='Invalid Request';
        $statusCode=400;
        
        $json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);
       
        $f_tokan=$data->f_tokan;
        $phone=$data->phone;
        
        if(isset($phone) )
        {
            if($phone)
            {
                $mobilewithcode=$phone;
                $exist= $this->Apidriver_model->is_registered1($mobilewithcode);
                $active= $this->Apidriver_model->activeuser($mobilewithcode);
                
                
                if(!$exist)
                {
                        $status='error';
                        $message='Record Not Found';
                        $statusCode=400;
                }
               
                else
                {
                    
                     if($active->status =='0')
                      {
                        $status='error';
                        $message='Your account not active..! contact admin';
                        $statusCode=400;
                   }else{
                    
                        $record = $this->db->query("SELECT * FROM `tbl_driver` WHERE `mobile_no`='$mobilewithcode'");
                        $result = $record->row();
                        $user_id= $result->driver_id;
                        $otpinsertornot=$this->db->query("SELECT user_id FROM mobile_otp WHERE user_id='$user_id'")->row_array();

                        if($otpinsertornot==""){
                         if($user_id=='Delivery100'){
                             
                                 $otpdata=array(
                                 'otp'=>'123654',
                                 'user_id'=>$user_id,
                               );
                         }else{
                                     $otp= random_int(100000, 999999);
                                 $otpdata=array(
                                    'otp'=>$otp,
                                    'user_id'=>$user_id,
                                );
                         }
                        
                    
                        $this->db->insert('mobile_otp',$otpdata);
                        $id=$this->db->insert_id();
                        
                        }
                              
                        $this->Apidriver_model->set_f_token_app($user_id, $f_tokan);
                       
                         $response['driver_id']=$result->driver_id;
                         $response['driver_name']=$result->driver_name;
                         $response['email']=$result->email;
                         $response['mobile_no']=$result->mobile_no;
                         $response['password']=$result->password;
                         $response['gender']=$result->gender;
                         $response['address']=$result->address .' '. $result->city .' '. $result->state.' '. $result->pin_code;
                         $response['latitude']=$result->latitude;
                         $response['logitude']=$result->logitude;
                         
                         if($result->driver_profile_pic !='' ){
                            $response['profile_image']=IMAGE_URL.$result->driver_profile_pic;
                         }else{
                            $response['profile_image']= IMAGE_URL.'assets/img/no-image-available.png'; 
                         }
                         
                        if($result->driving_license_image !='' ){
                           $response['driving_license_image']=IMAGE_URL.$result->driving_license_image;
                        }else{
                            $response['driving_license_image']= IMAGE_URL.'assets/img/no-image-available.png'; 
                        } 
                        if($result->driving_license_status =='0' ){
                           $response['driving_license_status']="Pending";
                        }
                        else  if($result->driving_license_status =='1' ){
                            $response['driving_license_status']="Approved";
                        }
                        else  if($result->driving_license_status =='2' ){
                            $response['driving_license_status']="Rejected";
                        }
                    
                         
                        $status='success';
                        $message='success';
                       // $detail='success';
                        $statusCode=200;
                    
                   }
                }
            }
            else
            {
                $status='error';
                $message='Please fill all required fields';
                $statusCode=400;
            }
        }
        else
        {
            $status='error';
            $message='Please fill all required fields';
            $statusCode=400;
        }
        
        $response['status']=$status;
        $response['statusCode']=$statusCode;
		$response['message']=$message;
		echo json_encode($response);
    }
	
	
	public function send_otp(){
         header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		$status='error';
		$message='Invalid Request';
        $statusCode=400;
        
        $json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);

        $otploginid=$data->user_id;
      
        if(isset($otploginid))
        {
            if($otploginid)
            {
                
                $user=$this->db->query("SELECT user_id FROM mobile_otp WHERE user_id='$otploginid'")->row_array();
                
                if(!empty($user))
                {
                         if($otploginid=='Driver100-Drv'){
                              $otp= 123654;
                                 $data=array(
                                 'otp'=>'123654',
                                 
                               );
                         }else{
                             $otp= random_int(100000, 999999);
                             
                            $data=array(
                                'otp'=>$otp,
                            );
                         }
        
                    $this->db->where('user_id',$otploginid);
                    $this->db->update('mobile_otp',$data);
                    $user_id=$user['user_id'];
                    
                     $delivernameuser=$this->db->query("SELECT * FROM tbl_driver WHERE driver_id='$user_id'")->row_array();
                         $number=$delivernameuser['mobile_no'];
                         $sql = "SELECT * FROM sms_template where (status = '0') and type = 'send_otp'";		
                		 $exist = $this->Apidriver_model->Execute($sql, array())->result();
                
                		$d_msg = $exist[0]->body ;
                           // $data = $this->Apidriver_model->getotp($payid); 
	   
                	
                		$user_name = $delivernameuser['driver_name'];
                		
                
                		$otp_now = $otp;
                
                		$msg = str_replace("mobile_number", $number ,$d_msg) ;
                
                		$msg = str_replace("user_name", $user_name ,$msg) ;
                
                		$msg = str_replace("otp_now", $otp_now ,$msg) ;
                
                		$db_data = array(
                		'phone' => $number,
                		'otp' => $otp_now ,
                		'user_id' => $user_name,
                		'added_by_web' => $_SERVER['HTTP_HOST'] ,
                		);
                
                		$insert_id = $this->Apidriver_model->Insert('all_otp',$db_data);
                
                		$status = send_text_msg($msg) ;       
        
                    $response['otp']=$otp;
                    $response['user_id']=$otploginid;

                    $status='success';
                    $message='OTP has been sent successfully.';
                    $statusCode=200;
                }
                else
                {
                    $status='error';
                    $message='Invalid Request.';
                    $statusCode=400;
                }
                
                
                
            }
            else
            {
                $status='error';
                $message='Please fill all required fields';
                $statusCode=400;
            }
        }
        else
        {
            $status='error';
            $message='Please fill all required fields';
            $statusCode=400;
        }
        
        $response['status']=$status;
        $response['statusCode']=$statusCode;
		$response['message']=$message;
		echo json_encode($response);
    }
    
    public function verify_otp(){
        
        header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		$status='error';
		$message='Invalid Request';
        $statusCode=400;
        
        $json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);

        $otp=$data->otp;
        $otploginid=$data->user_id;
      
        if(isset($otp) && isset($otploginid))
        {
            if($otp && $otploginid)
            {
                
                $verify=$this->Apidriver_model->verifyotp($otploginid);
                
                if(!empty($verify))
                {
                    if($otp==$verify['otp'])
                    {
                      
                      
                       
                        $response['id']=$verify['id'];
                        $response['driver_name']=$verify['driver_name'];
                        $response['driver_id']=$verify['driver_id'];
                        $response['email']=$verify['email'];
                        $response['mobile_no']=$verify['mobile_no'];
                        $response['gender']=$verify['gender'];
                        $response['pin_code']=$verify['pin_code'];
                        $response['city']=$verify['city'];
                        $response['state']=$verify['state'];

                        $status='Success';
                        $message='Success';
                        $statusCode=200;
                    }
                    else
                    {
                        $status='error';
                        $message='Invalid OTP..!';
                        $statusCode=400;
                    }
                }
                else
                {
                    $status='error';
                    $message='Something went wrong!';
                    $statusCode=400;
                }

            }
            else
            {
                $status='error';
                $message='Please fill all required fields';
                $statusCode=400;
            }
        }
        else
        {
            $status='error';
            $message='Please fill all required fields';
            $statusCode=400;
        }
        
        $response['status']=$status;
        $response['statusCode']=$statusCode;
		$response['message']=$message;
		echo json_encode($response);
    }

 
	public function register(){
         header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		$status='error';
		$message='Invalid Request';
        $statusCode=400;
        
        $json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);
       
        $name=$data->driver_name;
        $phone=$data->mobile_no;
        $email=$data->email;
        $pin_code=$data->pin_code;
        $address=$data->address;
      	$gender=$data->gender;
      
    
        
        if(isset($name) && isset($phone) && isset($email) && isset($pin_code) && isset($address) && isset($gender) )
        {
            if($name && $phone  && $email && $pin_code && $address && $gender )
            {
                $mobilewithcode=$phone;
                $email=$email;
                $exist= $this->Apidriver_model->is_registered($mobilewithcode,$email);
                
                if(!$exist)
                {
                  
			       $random_number = mt_rand(100, 999);
                   $driver_id=$name.$random_number."-Drv";
                   
                    $data=array(
                        'driver_name'=>$name,
                        'email'=>$email,
                        'pin_code'=>$pin_code,
                        'address'=>$address,
                         'gender' => $gender,
                        'mobile_no'=>$mobilewithcode,
                        'driver_id'=>$driver_id,
                        'password'=>$mobilewithcode,
                        'status'=> 0,
                    );

                    $this->db->insert('tbl_driver',$data);
                    $user_id=$this->db->insert_id(); 
                   
                    
                    $otp= random_int(100000, 999999);
                    $otpdata=array(
                        'otp'=>$otp,
                        'user_id'=>$driver_id,
                    );
                    $this->db->insert('mobile_otp',$otpdata);
                    $this->db->insert_id();
                   
                    
                  
                    $record = $this->db->query("SELECT * FROM `tbl_driver` WHERE `id`='$user_id'");
                    $results = $record->row();
                   
                    
                    
                    $response['user_id']=$results->driver_id;
                    $status='success';
                    $message='add success';
                    $statusCode=200;
                }
                else
                {
                    $record = $this->db->query("SELECT * FROM `tbl_driver` WHERE `mobile_no`='$mobilewithcode'");
                    $result = $record->row();
                    $uer_id=$result->driver_id;
                    
                     $otpinsertornot=$this->db->query("SELECT user_id FROM mobile_otp WHERE user_id='$result->driver_id'")->row_array();

                        if($otpinsertornot==""){
                        
                         $otp= random_int(100000, 999999);
                         $otpdata=array(
                            'otp'=>$otp,
                           'user_id'=>$result->driver_id,
                        );
    
                        $this->db->insert('mobile_otp',$otpdata);
                        $id=$this->db->insert_id();
                        
                        }
                    
                    
                   $response['user_id']=$uer_id;
                   $status='success';
                   $message='User Already Register';
                   $statusCode=200;
                
                
                }
            }
            else
            {
                $status='error';
                $message='Please fill all required fields';
                $statusCode=400;
            }
        }
        else
        {
            $status='error';
            $message='Please fill all required fields';
            $statusCode=400;
        }
        
        $response['status']=$status;
        $response['statusCode']=$statusCode;
		$response['message']=$message;
		echo json_encode($response);
    }
    
    
     public function profile_data(){
        
        header("Access-Control-Allow-Origin: *");
        header("Content-Type: application/json; charset=UTF-8");
        $status='error';
        $message='Invalid Request';
        $statusCode=400;
        
        $json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);

        $user_id=$data->user_id;
       
       
        if(isset($user_id))
        {
            if($user_id )
            {
                
               
            $userdata=$this->db->query("SELECT * FROM  tbl_driver  where driver_id = '$user_id'")->row();
                
                if(!empty($userdata))
                {

                         $response['id']=$userdata->id;
                         $response['driver_id']=$userdata->driver_id;
                         $response['driver_name']=$userdata->driver_name;
                         $response['email']=$userdata->email;
                         $response['mobile_no']=$userdata->mobile_no;
                         $response['password']=$userdata->password;
                         $response['gender']=$userdata->gender;
                         $response['address']=$userdata->address .' '. $userdata->city .' '. $userdata->state.' '. $userdata->pin_code;
                         $response['latitude']=$userdata->latitude;
                         $response['logitude']=$userdata->logitude;
                         
                          if($userdata->expire_date != null|| $userdata->expire_date !='' ){
                              $response['expire_date']=$userdata->expire_date ;
                            }else{
                                $response['expire_date']= 'NA'; 
                            }
                         
                         if($userdata->driver_profile_pic !='' ){
                            $response['profile_image']=IMAGE_URL.$userdata->driver_profile_pic;
                         }else{
                            $response['profile_image']= IMAGE_URL.'assets/img/no-image-available.png'; 
                         }
                         
                        if($userdata->driving_license_image !='' ){
                           $response['driving_license_image']=IMAGE_URL.$userdata->driving_license_image;
                        }else{
                            $response['driving_license_image']= IMAGE_URL.'assets/img/no-image-available.png'; 
                        }
                        
                        if($userdata->driving_license_status =='0' ){
                           $response['driving_license_status']="Pending";
                        }
                        else  if($userdata->driving_license_status =='1' ){
                            $response['driving_license_status']="Approved";
                        }
                        else  if($userdata->driving_license_status =='2' ){
                            $response['driving_license_status']="Rejected";
                        }
                    
                   
                   
                  
                    $message='Profile data';
                    $status='success';
                    $statusCode=200;
                }else{
                
                $status='error';
                $message='Data Not Found';
                $statusCode=400;
               }
            }
            else
            {
                $status='error';
                $message='Please fill all required fields';
                $statusCode=400;
            }
        }
        else
        {
            $status='error';
            $message='Please fill all required fields';
            $statusCode=400;
        }
        
        $response['status']=$status;
        $response['statusCode']=$statusCode;
        $response['message']=$message;
        echo json_encode($response);
    }
    
    
    
     public function profiledata_update(){
        
        header("Access-Control-Allow-Origin: *");
        header("Content-Type: application/json; charset=UTF-8");
        $status='error';
        $message='Invalid Request';
        $statusCode=400;
        
        $json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);

        $user_id=$data->user_id;
        $name=$data->driver_name;
        $email=$data->email;
        $phone=$data->mobile_no;
        $address=$data->address;
        $gender=$data->gender;
        $pin_code=$data->pin_code;
        $city=$data->city;
        $state=$data->state;
        $driving_license_status=$data->driving_license_status;
        $expired_date=$data->expired_date;
       
        if(isset($user_id) && isset($name)  && isset($email) && isset($phone) && isset($address) && isset($pin_code) && isset($gender) )
        {
            if($user_id  && $name  && $email  && $phone  && $address  && $pin_code && $gender)
            {
                 $data=array('driver_name'=>$name,
                             'email'=>$email,
                             'mobile_no'=>$phone,
                             'address'=>$address,
                             'pin_code'=>$pin_code,
                             'city'=>$city,
                             'state'=>$state,
                             'gender'=>$gender,
                             'expire_date' => $expired_date,
                             'driving_license_status' => $driving_license_status,
                             );
               
                 $this->Apidriver_model->update_data('tbl_driver','driver_id',$user_id,$data);
                  
                    $message='profile update';
                    $status='success';
                    $statusCode=200;
            }
            else
            {
                $status='error';
                $message='Please fill all required fields';
                $statusCode=400;
            }
        }
        else
        {
            $status='error';
            $message='Please fill all required fields';
            $statusCode=400;
        }
        
        $response['status']=$status;
        $response['statusCode']=$statusCode;
        $response['message']=$message;
        echo json_encode($response);
    } 
    
     public function image_update(){
            
         header("Access-Control-Allow-Origin: *");
        header("Content-Type: application/json; charset=UTF-8");
        $status='error';
        $message='Invalid Request';
        $statusCode=400;
 
        $json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);
       
        $user_id = $this->input->post('driver_id');
      
       
         if(!empty($user_id))
        {
            $time=time();
					
					$ext = pathinfo($_FILES['driver_file']['name'], PATHINFO_EXTENSION);
					$img_name='uploads/images/Licence/img_'.$time.".".$ext;
					
					$this->my_upload->upload($_FILES['driver_file']);
					
						if ( $this->my_upload->uploaded == true  ) 
					{
						$this->my_upload->allowed         		= array('image/*');
						$this->my_upload->file_new_name_body    = 'img_'.$time;
						//$this->my_upload->image_convert 		= 'jpg';
						$this->my_upload->jpeg_quality 			= 100;	
						$this->my_upload->image_resize          = true;
						$this->my_upload->image_ratio_fill   = true;
						$this->my_upload->image_x               = 270;
						$this->my_upload->image_y         		= 168;

						
						$this->my_upload->process('uploads/images/Licence/');
						if ( $this->my_upload->processed == true ) 
						{
							$this->my_upload->clean();  
						} 
						
					}
					
					
						$ext = pathinfo($_FILES['driver_photo']['name'], PATHINFO_EXTENSION);
					$profile_img='uploads/images/DriverProfile/img_'.$time.".".$ext;
					
					$this->my_upload->upload($_FILES['driver_photo']);
					
						if ( $this->my_upload->uploaded == true  ) 
					{
						$this->my_upload->allowed         		= array('image/*');
						$this->my_upload->file_new_name_body    = 'img_'.$time;
						//$this->my_upload->image_convert 		= 'jpg';
						$this->my_upload->jpeg_quality 			= 100;	
						$this->my_upload->image_resize          = true;
						$this->my_upload->image_ratio_fill   = true;
						$this->my_upload->image_x               = 270;
						$this->my_upload->image_y         		= 168;

						
						$this->my_upload->process('uploads/images/DriverProfile/');
						if ( $this->my_upload->processed == true ) 
						{
							$this->my_upload->clean();  
						} 
						
					}
                     
                    $data=array(
    					'driving_license_image' => $img_name,
    					'driver_profile_pic' => $profile_img,
                    );

              $this->Apidriver_model->update_data('tbl_driver','driver_id',$user_id,$data);
              $record = $this->db->query("SELECT id,driver_id,driver_profile_pic,driving_license_image FROM `tbl_driver` WHERE `driver_id`='$user_id'");
                    $result = $record->row_array(); 
 
                   
                     $response['record']['id']=$result['id'];
                     $response['record']['driver_id']=$result['driver_id'];
                    $response['record']['driving_license_image']=IMAGE_URL.$result['driving_license_image'];
                    $response['record']['driver_profile_pic']=IMAGE_URL.$result['driver_profile_pic'];
                    
                    $status='success';
                    $message='add success';
                    $statusCode=200;
        }
        else
        {
            $status='error';
            $message='Please fill all required fields';
            $statusCode=400;
        }
 
        $response['status']=$status;
        $response['statusCode']=$statusCode;
        $response['message']=$message;
        echo json_encode($response);
                              
              
        }
    


    public function updateDriverLocation()
    {
        header("Access-Control-Allow-Origin: *");
    	header("Content-Type: application/json; charset=UTF-8");
    	
    	$status='error';
        $message='Invalid Request';
        $statusCode=400;
    		
    	$json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);
        
        $driver_id=$data->driver_id;
    	$current_lat=$data->current_lat;
    	$current_long=$data->current_long;
        
    	
    	if($driver_id && $current_lat && $current_long)
    	{
    	    $this->db->where('driver_id',$driver_id);
    	    $this->db->delete('tbl_driver_currentLocation');
    	    
    	    $data=array(
    	        'driver_id'=>$driver_id,
    	        'curr_lat'=>$current_lat,
    	        'curr_long'=>$current_long,
    	        'entry_date'=>date('Y-m-d H:i:s'),
    	     );
    	     
    	     $this->db->insert('tbl_driver_currentLocation',$data);
    	     
    	    $status='success';
            $message='Location has been updated successfully';
            $statusCode=200;      
    	    
    	}
    	else
    	{
    	    $status='error';
            $message='Please fill in all required fields.';
            $statusCode=400;        
           
    	}
    	$response['status']=$status;
    	$response['message']=$message;
    	$response['statusCode']=$statusCode;
    	echo json_encode($response);
    }
    
    public function AcceptUserRequest()
    {
        header("Access-Control-Allow-Origin: *");
    	header("Content-Type: application/json; charset=UTF-8");
    	
    	$status='error';
        $message='Invalid Request';
        $statusCode=400;
    		
    	$json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);
        
        $request_id=$data->request_id;
    	$req_id=$data->gen_request_id;
    	$driver_id=$data->driver_id;
    	
    	if($request_id && $req_id && $driver_id)
    	{
    	    $qry="SELECT * FROM tbl_userwise_cabrequest 
    	    WHERE status=1 AND is_latest_request=1 AND req_id='$req_id'";
    	    $result=$this->db->query($qry)->row_array();
    	    
    	    if(!empty($result))
    	    {
    	        
        	    //$data=array('status'=>3);
        	   // $this->db->where('req_id',$req_id);
        	   // $this->db->update('tbl_userwise_cabrequest',$data);
        	    
        	    $status='error';
                $message='Request already accepted by other driver.';
                $statusCode=400; 
    	    }
    	    else
    	    {
    	        $datetime=date('Y-m-d H:i:s');
    	        
    	        
        	    $this->db->where('id',$driver_id);
        	    $this->db->update('tbl_driver',array('accepted_request_time'=>$datetime));
        	    
    	        $data=array('status'=>1);
        	    $this->db->where('id',$request_id);
        	    $this->db->update('tbl_userwise_cabrequest',$data);
        	    
        	   
        	    $status='success';
                $message='Request has been accepted successfully';
                $statusCode=200; 
    	    }
    	    
    	}
    	else
    	{
    	    $status='error';
            $message='Something went wrong';
            $statusCode=400;        
           
    	}
    	$response['status']=$status;
    	$response['message']=$message;
    	$response['statusCode']=$statusCode;
    	echo json_encode($response);
    }
    
    public function RejectUserRequest()
    {
        header("Access-Control-Allow-Origin: *");
    	header("Content-Type: application/json; charset=UTF-8");
    	
    	$status='error';
        $message='Invalid Request';
        $statusCode=400;
    		
    	$json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);
        
        $request_id=$data->request_id;
    	$reason=$data->reason;
    	
    	if($request_id && $reason)
    	{
    	    $data=array('status'=>2,'reject_reason'=>$reason);
    	    $this->db->where('id',$request_id);
    	    $this->db->update('tbl_userwise_cabrequest',$data);
    	    
    	   
    	    $status='success';
            $message='Request has been rejected successfully';
            $statusCode=200;      
    	    
    	}
    	else
    	{
    	    $status='error';
            $message='Something went wrong';
            $statusCode=400;        
           
    	}
    	$response['status']=$status;
    	$response['message']=$message;
    	$response['statusCode']=$statusCode;
    	echo json_encode($response);
    }
    
    public function CabRequestList()
    {
        header("Access-Control-Allow-Origin: *");
    	header("Content-Type: application/json; charset=UTF-8");
    	
    	$status='error';
        $message='Invalid Request';
        $statusCode=400;
    		
    	$json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);
        
        $driver_id=$data->driver_id;
    	if($driver_id)
    	{
    	    $qry="SELECT r.*,DATE_FORMAT(r.entry_date,'%d/%m/%Y %h:%i %p') as requestdate,vt.name,u.f_name,u.mobile_no,u.email_id FROM tbl_userwise_cabrequest r 
    	    INNER JOIN tbl_user u ON u.id=r.user_id
    	    INNER JOIN tbl_vehicletype vt ON vt.id=r.type_id
    	    WHERE r.is_latest_request=1 AND r.driver_id='$driver_id' ORDER BY r.id DESC";
    	    $result=$this->db->query($qry)->result_array();
    	    
    	    if(!empty($result))
    	    {
    	        $i=0;
    	        foreach($result as $row)
    	        {
    	            $response['list'][$i]['id']=$row['id'];
    	            $response['list'][$i]['req_id']=$row['req_id'];
    	            $response['list'][$i]['pickup_address']=$row['pickup_address'];
    	            $response['list'][$i]['pickup_lat']=$row['pickup_lat'];
    	            $response['list'][$i]['pickup_long']=$row['pickup_long'];
    	            $response['list'][$i]['drop_address']=$row['drop_address'];
    	            $response['list'][$i]['drop_lat']=$row['drop_lat'];
    	            $response['list'][$i]['drop_long']=$row['drop_long'];
    	            $response['list'][$i]['user_journey_distance']=$row['user_journey_distance'];
    	            $response['list'][$i]['per_km_fare']=$row['per_km_fare'];
    	            $response['list'][$i]['user_name']=$row['f_name'];
    	            $response['list'][$i]['user_mobileno']=$row['mobile_no'];
    	            $response['list'][$i]['user_email']=$row['email_id'];
    	            $response['list'][$i]['total_fare']=(int)round($row['user_journey_distance']*$row['per_km_fare']);
    	            $response['list'][$i]['vehicle_type']=$row['name'];
    	            $response['list'][$i]['request_date']=$row['requestdate'];
    	            
    	            if($row['status']==0)
    	            {
    	                $status="Pending";
    	            }
    	            else if($row['status']==1 && $row['driver_id']==$driver_id)
    	            {
    	                $status="Accepted";
    	            }
    	            else if($row['status']==1 && $row['driver_id'] != $driver_id)
    	            {
    	                $status="Accepted by other";
    	            }
    	            else if($row['status']==2 && $row['driver_id']==$driver_id)
    	            {
    	                $status="Rejected";
    	            }
    	           
    	            $response['list'][$i]['status']=$status;
    	            $i++;
    	        }
    	        
    	       $status='success';
                $message='success';
                $statusCode=200;     
        	    
    	    }
    	    else
    	    {
    	        $response['list']=[]; 
        	    $status='success';
                $message='Data not found';
                $statusCode=200; 
    	    }
    	    
    	      
    	    
    	}
    	else
    	{
    	    $status='error';
            $message='Something went wrong';
            $statusCode=400;        
           
    	}
    	$response['status']=$status;
    	$response['message']=$message;
    	$response['statusCode']=$statusCode;
    	echo json_encode($response);
    }
    
    // public function Startride()
    // {
    //     header("Access-Control-Allow-Origin: *");
    // 	header("Content-Type: application/json; charset=UTF-8");
    	
    // 	$status='error';
    //     $message='Invalid Request';
    //     $statusCode=400;
    		
    // 	$json = $this->security->xss_clean(file_get_contents('php://input'));
    //     $data = json_decode($json);
        
    //     $booking_id=$data->booking_id;
    	
    // 	if($booking_id)
    // 	{
    	    
    // 	    $qry="SELECT id,is_cancle,cancle_reason FROM tbl_booking WHERE book_id='$booking_id'";
    // 	    $row=$this->db->query($qry)->row_array();
    // 	    if(!empty($row))
    // 	    {
    	        
    // 	        if($row['is_cancle']==0)
    // 	        {
    // 	            $data=array('ride_status'=>1);
    //         	    $this->db->where('book_id',$booking_id);
    //         	    $this->db->update('tbl_booking',$data);
            	    
    //         	    //booking ride history
            	    
    //         	    $data_sub=array(
    //         	        'booking_id'=>$row['id'],
    //         	        'status'=>1,
    //         	        'entry_date'=>date('Y-m-d H:i:s'),
    //         	        );
            	        
    //         	    $this->db->insert('tbl_booking_ridehistory',$data_sub);     
    //         	    $status='success';
    //                 $message='Ride has been start successfully';
    //                 $statusCode=200;      
    // 	        }
    // 	        else
    // 	        {
    // 	            $status='error';
    //                 $message='This cab canclled by users becuase of '.$row['cancle_reason'];
    //                 $statusCode=400;   
    // 	        }
    // 	    }
    // 	    else
    // 	    {
    // 	        $status='error';
    //             $message='Something went wrong';
    //             $statusCode=400;   
    // 	    }
    // 	}
    // 	else
    // 	{
    // 	    $status='error';
    //         $message='Something went wrong';
    //         $statusCode=400;        
           
    // 	}
    // 	$response['status']=$status;
    // 	$response['message']=$message;
    // 	$response['statusCode']=$statusCode;
    // 	echo json_encode($response);
    // }
    
    public function Completeride()
    {
        header("Access-Control-Allow-Origin: *");
    	header("Content-Type: application/json; charset=UTF-8");
    	
    	$status='error';
        $message='Invalid Request';
        $statusCode=400;
    		
    	$json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);
        
        $booking_id=$data->booking_id;
    	if($booking_id)
    	{
    	    
    	    $qry="SELECT b.*,
    	    f.wait_charge,f.wait_time_limit
    	    FROM tbl_booking b
    	    INNER JOIN tbl_fare f ON f.vehicle_type=b.type_id
    	    WHERE b.book_id='$booking_id'";
    	    $row=$this->db->query($qry)->row_array();
    	    if(!empty($row))
    	    {
    	        
    	        if($row['is_cancle']==0)
    	        {
    	            if($row['payment_status']==0)   
    	            {
    	                 $total_payble=round(($row['per_km_fare']*$row['user_journey_distance'])+$row['conv_charge'],2); 
            	         $total_payble=round($total_payble+$row['total_wait_charge']);
            	            
    	                $status='error';
                        $message='Please collect Rs.'.$total_payble.' payment from the user';
                        $statusCode=400; 
    	            }
    	            else if($row['payment_status']==1 && $row['post_payment_status']==0 && $row['total_wait_charge']>0)
    	            {
    	                 $total_payble=0; 
            	         $total_payble=round($total_payble+$row['total_wait_charge']);
            	            
    	                $status='error';
                        $message='Please collect Rs.'.$total_payble.' waiting charge from the user';
                        $statusCode=400; 
    	            }
    	            else
    	            {
    	                //booking ride history
    	                 $data_update=array(
                           'ride_status'=>2,
                          );
                          
                        $this->db->where('book_id',$booking_id);  
                        $this->db->update('tbl_booking',$data_update);
    	                
                	    $data_sub=array(
                	        'booking_id'=>$row['id'],
                	        'status'=>2,
                	        'entry_date'=>date('Y-m-d H:i:s'),
                	    );
                	        
                	    $this->db->insert('tbl_booking_ridehistory',$data_sub);    
                	    
                	    $status='success';
                        $message='Ride has been completed successfully';
                        $statusCode=200; 
    	            }
            	         
    	        }
    	        else
    	        {
    	            $status='error';
                    $message='This cab canclled by users becuase of '.$row['cancle_reason'];
                    $statusCode=400;   
    	        }
    	    }
    	    else
    	    {
    	        $status='error';
                $message='Something went wrong';
                $statusCode=400;   
    	    }
    	}
    	else
    	{
    	    $status='error';
            $message='Something went wrong';
            $statusCode=400;        
           
    	}
    	$response['status']=$status;
    	$response['message']=$message;
    	$response['statusCode']=$statusCode;
    	echo json_encode($response);
    }
    
    public function ride_history()
    {
        header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		$status='error';
		$message='Invalid Request';
        $statusCode=400;
        
        $json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);
        
        
        $driver_id=$data->driver_id;
        $pageno= $data->pageno;
        
        if($driver_id)
        {
             $limit = 10;  
                if($data->pageno)
                { 
                    $pn  = $data->pageno; 
                } 
                else { 
                    $pn=1; 
                };  
                
                $start_from = ($pn-1) * $limit;
                
            $qry="SELECT b.*,DATE_FORMAT(b.entry_date,'%d/%m/%Y %H:%i %p') AS entrydate,vt.name as vehicle_name 
            FROM tbl_booking b
            INNER JOIN tbl_vehicletype vt ON vt.id=b.type_id WHERE driver_id='$driver_id'";
            
            $limit_qry=" ORDER BY b.id DESC LIMIT $start_from,$limit";
            $result=$this->db->query($qry.$limit_qry)->result_array();
            
            
            $total=$this->db->query($qry)->num_rows();
          
            $number_of_page = ceil ($total / $limit); 
            
            if(!empty($result))
            {
                $i=0;
                foreach($result as $row)
                {
                    $response['list'][$i]['id']=$row['id'];
                    $response['list'][$i]['book_id']=$row['book_id'];
                    $response['list'][$i]['pickup_address']=$row['pickup_address'];
                    $response['list'][$i]['drop_address']=$row['drop_address'];
                    $response['list'][$i]['vehicle']=$row['vehicle_name'];
                    $response['list'][$i]['user_journey_distance']=$row['user_journey_distance'];
                    $response['list'][$i]['total_fare']=$row['total_fare'];
                    $response['list'][$i]['total_wait_charge']=$row['total_wait_charge'];
                    $response['list'][$i]['grand_total']=$row['grand_total'];
                    
                    
                    if($row['ride_status']==0) 
                    {
                        $ride_status="Pending";
                    }
                    else if($row['ride_status']==1) 
                    {
                        $ride_status="Start";
                    }
                    else if($row['ride_status']==2) 
                    {
                        $ride_status="Completed";
                    } 
                    else if($row['is_cancle']==1) 
                    {
                        $ride_status="Cancelled";
                    }
                    $response['list'][$i]['ride_status']=$ride_status;
                    $response['list'][$i]['payment_status']=($row['payment_status']==0) ? 'Pending' : 'Paid';
                    $response['list'][$i]['is_cancle']=$row['is_cancle'];
                    $response['list'][$i]['cancle_date']=$row['cancle_date'];
                    $response['list'][$i]['cancle_reason']=$row['cancle_reason'];
                    $response['list'][$i]['entry_date']=$row['entrydate'];
                    $i++;
                }
                
                if($number_of_page > 1)
                {
                    if($number_of_page == $pn)
                    {
                        $response['nextpage']=0;
                    }
                    else
                    {
                        $response['nextpage']=$pn+1;
                    }
                }
                else
                {
                    $response['nextpage']=0;
                }
                
                $message='Data found';
                $status='success';
                $statusCode=200;
            }
            else
            {
                 $response['list']=[];
                $message='Data Not found';
                 $status='success';
                 $statusCode=200;
            }
            
            
        }
        else
        {
            $status='error';
            $message='Please fill all required fields';
            $statusCode=400;
        }
        
        $response['status']=$status;
        $response['statusCode']=$statusCode;
		$response['message']=$message;
		echo json_encode($response);
    }
    
    
    public function arrivPickuplocation()
    {
        header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		$status='error';
		$message='Invalid Request';
        $statusCode=400;
        
        $json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);
        
        
        $booking_id=$data->booking_id;
        $driver_id=$data->driver_id;
        
        if($booking_id && $driver_id)
        {
            $qry="SELECT u.mobile_no,u.f_name,u.f_token_app
            FROM tbl_booking b 
            INNER JOIN  tbl_user u ON u.id = b.user_id  WHERE b.book_id='$booking_id'";
            
            $row=$this->db->query($qry)->row_array();
            
            
            if(!empty($row))
            {
                $sql = "SELECT * FROM sms_template where (status = '0') and type = 'send_otp'";		
                $exist = $this->db->query($sql, array())->result();
           
                $d_msg = $exist[0]->body ;

                $user_name = $row['f_name'] ;
                

                $otp_now = $otp = sprintf("%06d", mt_rand(0, 999999));

                $msg = str_replace("mobile_number", $row['mobile_no'] ,$d_msg) ;

                $msg = str_replace("user_name", $user_name ,$msg) ;

                $msg = str_replace("otp_now", $otp_now ,$msg) ;

                $update_array=array(
                    'otp'=>$otp_now,
                    'is_arrive'=>1
                    );
                $this->db->Update('tbl_booking',$update_array,array('book_id' => $booking_id));

                send_text_msg($msg);
                
                if($row['f_token_app'])
                {
                    $body="Driver has been arrived at your pickup location";
    	            $title="Driver arrived";
    	            sendNotificationapp($row['f_token_app'],$body,$title);
                }
                $status='success';
                $message='OTP has been sent successfully';
                $statusCode=200; 
            }
            else
            {
                $status='error';
                $message='Something went wrong..!';
                $statusCode=400; 
            }
        }
        else
        {
            $status='error';
            $message='Please fill all required fields';
            $statusCode=400; 
        }
        
        $response['status']=$status;
        $response['statusCode']=$statusCode;
		$response['message']=$message;
		echo json_encode($response);
    }
    
    public function Verifybookingotp()
    {
        header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
	
		$status='error';
        $message='Invalid Request';
        $statusCode=400;
        
		$json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);
       
       
		$otp=$data->otp;
		$booking_id=$data->booking_id;
		
		if($booking_id && $otp)
		{
		    $sql="SELECT b.otp,b.otp_verify_status
            FROM tbl_booking b 
            WHERE b.book_id='$booking_id'";
            
		    $verify = $this->db->query($sql)->row_array(); 
		    
		    
		    if(!empty($verify))
		    {
		        if($otp==$verify['otp'])
	            {
	                
	                if($verify['otp_verify_status']==0)
	                {
	                     $data=array(
	                        'otp_verify_status'=>1
	                    );
	                    
	                    $this->db->Where('book_id',$booking_id);
	                    $this->db->update('tbl_booking',$data);
	                    
	                     $status='success';
                        $message='OTP has been verified successfully';
                        $statusCode=200;
	                }
	                else
	                {
	                    $status='error';
                        $message='OTP already verified';
                        $statusCode=400;
	                }
	                
                   
                    
	            }
	            else
	            {
	                $status='error';
                    $message='Invalid OTP';
                    $statusCode=400;
                    
	            }
		       
		    }
		    else
		    {
		        $status='error';
                $message='Invalid OTP';
                $statusCode=400;
                
		    }
		}
		else
		{
		    $status='error';
            $message='Something went wrong please try again..!';
            $statusCode=400;
           
		}
		
		$response['status']=$status;
		$response['message']=$message;
		$response['statusCode']=$statusCode;
		echo json_encode($response);
    }
    
    public function trip_history_details()
    {
        header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		$status='error';
		$message='Invalid Request';
        $statusCode=400;
        
        $json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);
        
        
        $booking_id=$data->booking_id;
        
        
        if($booking_id)
        {
            $qry="SELECT b.*,DATE_FORMAT(b.entry_date,'%d/%m/%Y %H:%i %p') AS entrydate,
            vt.name as vehicle_name,vt.image as vehicle_image,
            u.f_name as user_name,u.mobile_no as user_mobno,v.number
            FROM tbl_booking b 
            INNER JOIN tbl_vehicletype vt ON vt.id=b.type_id 
            INNER JOIN tbl_vehicle v ON v.driver_id=b.driver_id
            INNER JOIN  tbl_user u ON u.id = b.user_id  WHERE b.book_id='$booking_id'";
            
            $row=$this->db->query($qry)->row_array();
           
            if(!empty($row))
            {
                
                $response['id']=$row['id'];
                $response['book_id']=$row['book_id'];
                $response['pickup_address']=$row['pickup_address'];
                $response['pickup_lat']=$row['pickup_lat'];
                $response['pickup_long']=$row['pickup_long'];
                $response['drop_address']=$row['drop_address'];
                $response['drop_lat']=$row['drop_lat'];
                $response['drop_long']=$row['drop_long'];
                $response['vehicle']=$row['vehicle_name'];
                $response['vehicle_image']=base_url().$row['vehicle_image'];
                $response['user_journey_distance']=$row['user_journey_distance'];
                $response['total_fare']=$row['total_fare'];
                $response['total_wait_charge']=$row['total_wait_charge'];
                $response['grand_total']=$row['grand_total'];
                $response['user_name']=$row['user_name'];
               
                $response['user_mobile_no']=$row['user_mobno'];
                
               
                if($row['ride_status']==0) 
                {
                    $ride_status="Pending";
                }
                else if($row['ride_status']==1) 
                {
                    $ride_status="Start";
                }
                else if($row['ride_status']==2) 
                {
                    $ride_status="Completed";
                }
                else if($row['is_cancle']==1) 
                {
                    $ride_status="Cancelled";
                }
                $response['ride_status']=$ride_status;
                $response['payment_status']=($row['payment_status']==0) ? 'Pending' : 'Paid';
                $response['is_cancle']=$row['is_cancle'];
                $response['paymenttype']=$row['paymenttype'];
                $response['cancle_date']=$row['cancle_date'];
                $response['cancle_reason']=$row['cancle_reason'];
                $response['entry_date']=$row['entrydate'];
                
                $response['is_arrive']=$row['is_arrive'];
                
                $response['conv_charge']=$row['conv_charge'];
                $response['post_paymenttype']=$row['post_paymenttype'];
                $response['final_grandtotal']=$row['final_grandtotal'];
                $response['vehical_number']=$row['number'];
                $message='Data found';
                $status='success';
                $statusCode=200;
            }
            else
            {
                
                $message='Data Not found';
                 $status='success';
                 $statusCode=400;
            }
        }
        else
        {
            $status='error';
            $message='Please fill all required fields';
            $statusCode=400;
        }
        
        $response['status']=$status;
        $response['statusCode']=$statusCode;
		$response['message']=$message;
		echo json_encode($response);
    }
    
    
    public function driver_online_offline()
    {
        header("Access-Control-Allow-Origin: *");
		header("Content-Type: application/json; charset=UTF-8");
		$status='error';
		$message='Invalid Request';
        $statusCode=400;
        
        $json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);
        
        
        $driver_id=$data->driver_id;
        
        
        if($driver_id)
        {
            $sql="SELECT is_online FROM tbl_driver WHERE id='$driver_id'";
            
		    $row = $this->db->query($sql)->row_array(); 
		    
		    
		    if(!empty($row))
            {
                if($row['is_online']==1)
                {
                    $data=array(
                        'is_online'=>0
                    );
                }
                else
                {
                     $data=array(
                        'is_online'=>1
                    );
                }
                
                
                 $this->db->Where('id',$driver_id);
                $this->db->update('tbl_driver',$data);
                
                 $status='success';
                $message='Status has been updated successfully';
                $statusCode=200;
            }
            else
            {
                $status='error';
                $message='Something went wrong..!';
                $statusCode=400;
            }
            
            
           
        }
        else
        {
            $status='error';
            $message='Please fill all required fields';
            $statusCode=400;
        }
        
        $response['status']=$status;
        $response['statusCode']=$statusCode;
		$response['message']=$message;
		echo json_encode($response);
    }
    
    public function completeridewith_cod()
    {
        header("Access-Control-Allow-Origin: *");
    	header("Content-Type: application/json; charset=UTF-8");
    	
    	$status='error';
        $message='Invalid Request';
        $statusCode=400;
    		
    	$json = $this->security->xss_clean(file_get_contents('php://input'));
        $data = json_decode($json);
        
        $booking_id=$data->booking_id;
       
    	
    	if($booking_id)
    	{
    	    $qry="SELECT * FROM tbl_booking WHERE book_id='$booking_id'";
            $row=$this->db->query($qry)->row_array();
            
            if(!empty($row))
            {
    	        
    	        if($row['payment_status']==0)
    	        {
    	            $total_payble=round(($row['per_km_fare']*$row['user_journey_distance'])+$row['conv_charge'],2); 
    	            $total_payble=round($total_payble+$row['total_wait_charge']);
    	        }
                else
                {
                    $total_payble=round($row['total_wait_charge']);
                   
                }
                
    	        
                $data_update=array(
                   'ride_status'=>2,
                   'final_grandtotal'=>$total_payble,
                   'payment_status'=>1,
                   'post_paymenttype'=>'COD',
                   'post_payment_status'=>1,
                  );
                  
                $this->db->where('book_id',$booking_id);  
                $this->db->update('tbl_booking',$data_update);
                
                 $data_sub=array(
        	        'booking_id'=>$row['id'],
        	        'status'=>2,
        	        'entry_date'=>date('Y-m-d H:i:s'),
        	    );
        	        
        	    $this->db->insert('tbl_booking_ridehistory',$data_sub);   
                
                
                //collect cod
              
                if($total_payble > 0)
                {
                     $data_cod=array(
            	        'book_id'=>$row['book_id'],
            	        'driver_id'=>$row['driver_id'],
            	        'cod_amt'=>$total_payble,
            	        'status'=>0,
            	        'created_at'=>date('Y-m-d H:i:s'),
            	    );
            	        
            	    $this->db->insert('tbl_cod_collection',$data_cod);
                }
                
              
                $message='Ride has been collect successfully.';
                $status='success';
                $statusCode=200;
    	    }
    	    else
    	    {
    	        $status='error';
                $message='This booking not valid';
                $statusCode=400;  
    	    }
    	}
    	else
    	{
    	    $status='error';
            $message='Booking id required';
            $statusCode=400;    
    	}
    	
        $response['status']=$status;
    	$response['message']=$message;
    	$response['statusCode']=$statusCode;
    	echo json_encode($response);
    }
}
?>